#!/usr/bin/env python

import sys, os

template = '''#pragma once

#define THE_NUMBER {}
#define THE_ARG1 {}
#define THE_ARG2 {}
'''

input_file = os.path.join(os.environ['MESON_SOURCE_ROOT'], 'raw.dat')
output_file = os.path.join(os.environ['MESON_BUILD_ROOT'], 'generated.h')

with open(input_file) as f:
    data = f.readline().strip()
with open(output_file, 'w') as f:
    f.write(template.format(data, sys.argv[1], sys.argv[2]))
